package gov.va.med.mhv.sm.admin.enums;

public enum PerformerTypeEnum {

	SELF (0L, "self"),
	HELP_DESK(1L, "help desk"),
	ADMINISTRATOR(2L, "administrator"),
	SYSTEM(3L, "system");
	
	private Long id;
	private String name;
	
	private PerformerTypeEnum(Long id, String name){
		this.id = id;
		this.name = name;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public static PerformerTypeEnum valueOf(Long value){
		for(PerformerTypeEnum f : PerformerTypeEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no enum found");
	}
		
}
